DROP TABLE IF EXISTS `site_core_texts`;
CREATE TABLE `site_core_texts` (
  `module_id` int(11) NOT NULL,
  `sub_id` varchar(50) NOT NULL,
  `text_image` int(1) NOT NULL,
  `text_status` int(1) NOT NULL DEFAULT '1',
  `text_title_align` varchar(10) NOT NULL,
  `text_subtitle_align` varchar(10) NOT NULL,
  `text_title_valign` varchar(10) NOT NULL,
  `text_subtitle_valign` varchar(10) NOT NULL,
  `text_title_size` int(2) NOT NULL,
  `text_title_size_lg` int(2) NOT NULL,
  `text_title_size_md` int(2) NOT NULL,
  `text_title_size_sm` int(2) NOT NULL,
  `text_title_size_xs` int(2) NOT NULL,
  `text_subtitle_size` int(2) NOT NULL,
  `text_subtitle_size_lg` int(2) NOT NULL,
  `text_subtitle_size_md` int(2) NOT NULL,
  `text_subtitle_size_sm` int(2) NOT NULL,
  `text_subtitle_size_xs` int(2) NOT NULL,
  `text_pt_css` varchar(255) NOT NULL,
  `text_pt_css_title` varchar(255) NOT NULL,
  `text_pt_css_subtitle` varchar(255) NOT NULL,
  `text_menu` varchar(1) NOT NULL,
  KEY `module_id` (`module_id`),
  KEY `sub_id` (`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_texts_lang`;
CREATE TABLE `site_core_texts_lang` (
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `sub_id` varchar(50) NOT NULL,
  `text_title` varchar(255) NOT NULL,
  `text_subtitle` text NOT NULL,
  `text_header` text NOT NULL,
  `text_footer` text NOT NULL,
  `text_block_1_title` varchar(255) NOT NULL,
  `text_block_1_header` text NOT NULL,
  `text_block_2_title` varchar(255) NOT NULL,
  `text_block_2_header` text NOT NULL,
  `text_block_3_title` varchar(255) NOT NULL,
  `text_block_3_header` text NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` longtext NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `module_id` (`module_id`,`lang_id`),
  KEY `sub_id` (`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
